//
//  TTTGame.h
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/4/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "TTTSymbol.h"
#import "TTTGameGrid.h"

typedef enum {
    Inactive=-1, Active=0, Won=1, Draw=2
} STATE;

typedef enum {
    Player1=0, Player2=1
} PLAYER;

#define TTTGAMEKEYPLAYCOUNT "TTTGameKeyPlaycount"
#define TTTGAMEKEYSTATE "TTTGameKeyState"
#define TTTGAMEKEYGRIDSTATE "TTTGameKeyGridState"
#define TTTGAMEKEYCURRENTPLAYER "TTTGameKeyCurrentPlayer"
#define TTTGAMEKEYCURRENTSYMBOL "TTTGameKeyCurrentSymbol"

@interface TTTGame : NSObject{
    
    @private STATE gameState;
	@private TTTSymbol *currentSymbol;
	@private PLAYER currentPlayer;
	@private PLAYER winningPlayer;
	@private NSString *PlayerOneName, *PlayerTwoName;
	
	@private TTTGameGrid *gameGrid;
	
	@private int playCount;
}

    - (id) init;
    - (id) initFromDictionary: (NSDictionary *) savedGameDictionary;
    - (TTTGameGrid *) getGameGrid;
    - (void) setPlayerNames :(NSString *) FirstPlayer : (NSString *) SecondPlayer;
    - (NSString *) getPlayerOneName;
    - (NSString *) getPlayerTwoName;
    - (NSString *) getCurrentPlayerName;
    - (NSString *)  getWinningPlayerName;
    - (TTTSymbol *) getCurrentSymbol;
    - (void) checkResultAndSetState;
    - (BOOL) play :(int) x :(int) y;
    - (BOOL) isActive;
    - (BOOL) isWon;
    - (BOOL) isDrawn;
    - (int) getPlayCount;
    - (NSDictionary *) toDictionary;
@end
